/* ------------------------------------------------------------------------ */
/*  @@ Usage                                        *** MSC Version ***     */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   char far *LoadDriver (char *szDrvName)                                 */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Loads driver into memory with the driver name specified. The       */
/*       driver is always loaded to the offset 0 of a segement.             */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szDrvName :- Driver name to be loaded.                             */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Pointer to the loaded driver if successful, else returns NULL      */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <dos.h>
#include  <stdlib.h>
#include  <fcntl.h>
#include  <string.h>

char far *LoadDriver (char *szDrvName)
{
    char        far *lpDrvPtr = 0 ;
    char        far *lpPtr ;
    char        szDrvFile[100] ;
    char        *pPtr ;
    int         Handle = 1 ;
    unsigned    wTemp, wDrvSize ;
    struct find_t    stFile ;


    /* locate driver through environment parameter */
    if (pPtr = getenv("SOUND"))
    {
        strcat(strcpy(szDrvFile,pPtr),"\\DRV\\") ;
        strcat(szDrvFile,szDrvName);

        /* handle set to 0, if found */
        Handle = _dos_findfirst(szDrvFile,_A_NORMAL,&stFile) ;
     }

     /* locate driver in current directory */
     if (Handle)
     {
        strcpy(szDrvFile,szDrvName) ;

        /* handle set to 0, if found */
        Handle = _dos_findfirst(szDrvFile,_A_NORMAL,&stFile) ;
     }

     if (Handle)
        printf("Driver file does not exist.\n") ;
     else
     {
        if (_dos_open(szDrvFile,O_RDONLY,&Handle))
            printf("Open %s error.\n",szDrvFile) ;
        else
        {
            wDrvSize = (unsigned) filelength(Handle) ;

            if (!_dos_allocmem(((wDrvSize + 15) >> 4),&wTemp))
            {
                FP_SEG(lpDrvPtr) = wTemp ;
                FP_OFF(lpDrvPtr) = 0 ;

                lpPtr = lpDrvPtr;

                if (_dos_read(Handle,lpPtr,wDrvSize,&wTemp))
                {
                    _dos_freemem(FP_SEG(lpDrvPtr)) ;
                    lpDrvPtr = 0 ;
                }
            }
            else
                printf("Memory allocation error\n");

           _dos_close(Handle) ;
        }
    }


    return(lpDrvPtr) ;
}

